float4x4 g_view_projection_matrix;
float4x4 g_world_matrix;
float4	g_light;
float4	g_camera_eye_vector;
float4	g_diffuse_mtrl;
float4	g_ambient_mtrl;

struct OutputVS
{
	float4 posH		: POSITION;
	float2 UV		: TEXCOORD0;
	float3 Light		: TEXCOORD1;
	float3 Norm		: TEXCOORD2;
	float3 View		: TEXCOORD3;
};

OutputVS SpecularVS( float4 posL : POSITION , float3 normal : NORMAL , float2 UV : TEXCOORD0 )
{
	OutputVS outVS = (OutputVS)0;
	
	outVS.posH = posL;
	
	outVS.posH = mul( posL , g_world_matrix );
	outVS.posH = mul( outVS.posH , g_view_projection_matrix );
	
	outVS.UV	= UV;
	outVS.Light	= g_light;
	outVS.Norm	= mul( normal , g_world_matrix );
	
	float4 posWorld = mul( posL , g_world_matrix );
	
	outVS.View = g_camera_eye_vector - posWorld;
	
	return outVS;
}


float4 SpecularPS( float2 UV : TEXCOORD0 ,
		   float3 Light : TEXCOORD1 ,
		   float3 Norm : TEXCOORD2 ,
		   float3 View : TEXCOORD3 ) : COLOR
{
	Norm	= normalize( Norm );
	Light	= normalize( Light );
	View	= normalize( View );
	
	//Calculate diffuse color amount
	float Diff = saturate( dot( Norm , Light ) );
	if( Diff < 0.0f )
		Diff = 0.0f;
	
	//R = 2 * (N.L) * N - L
	float3 Reflect = normalize( 2 * Diff * Norm - Light );
	
	// R.V^n
	float Specular = pow( saturate( dot( Reflect , View ) ) , 8 );
	
	//I = Dcolor * Dintensity * N.L + Scolor * Sintensity + (R.V)^2
	return ( g_ambient_mtrl * Diff + g_diffuse_mtrl * Specular ) * g_ambient_mtrl.w;
}

technique Default
{
	pass p0
	{
		vertexShader	= compile vs_3_0 SpecularVS();
		pixelShader	= compile ps_2_0 SpecularPS();
	}
}